<?php

header('Content-Type: application/json; charset=utf-8');

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  http_response_code(200);
  exit;
}

function respond($arr, $code = 200) {
  http_response_code($code);
  echo json_encode($arr, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
  exit;
}

$baseDir   = __DIR__;
$uploadDir = $baseDir . "/uploads/";
$csvPath   = $baseDir . "/env_data_7days_final.csv";
$pyPath    = $baseDir . "/freshness_cli.py";

if (!file_exists($csvPath)) {
  respond(["error" => "CSV not found", "path" => $csvPath], 500);
}
if (!file_exists($pyPath)) {
  respond(["error" => "Python script not found", "path" => $pyPath], 500);
}
if (!is_dir($uploadDir)) {
  respond(["error" => "uploads/ folder not found", "path" => $uploadDir], 500);
}
if (!is_writable($uploadDir)) {
  respond(["error" => "uploads/ not writable. Please chmod it.", "path" => $uploadDir], 500);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  respond(["error" => "Use POST"], 405);
}

$openedDays = isset($_POST["opened_days"]) ? floatval($_POST["opened_days"]) : 0.0;
$storedDays = isset($_POST["stored_days"]) ? floatval($_POST["stored_days"]) : null; // 可选
$note       = isset($_POST["note"]) ? trim($_POST["note"]) : "";

$hasFile = isset($_FILES["milk_photo"]) && $_FILES["milk_photo"]["error"] === UPLOAD_ERR_OK;

$savedImgPath = "";
if ($hasFile) {
  $tmpName = $_FILES["milk_photo"]["tmp_name"];
  $size    = intval($_FILES["milk_photo"]["size"]);

  if ($size > 5 * 1024 * 1024) {
    respond(["error" => "File too large (>5MB)"], 400);
  }

  $finfo = finfo_open(FILEINFO_MIME_TYPE);
  $mime  = finfo_file($finfo, $tmpName);
  finfo_close($finfo);

  $ext = "";
  if ($mime === "image/jpeg") $ext = "jpg";
  else if ($mime === "image/png") $ext = "png";
  else if ($mime === "image/webp") $ext = "webp";
  else {
    respond(["error" => "Unsupported image type", "mime" => $mime], 400);
  }

  $filename = "milk_" . date("Ymd_His") . "_" . bin2hex(random_bytes(4)) . "." . $ext;
  $savedImgPath = $uploadDir . $filename;

  if (!move_uploaded_file($tmpName, $savedImgPath)) {
    respond(["error" => "Failed to save uploaded file"], 500);
  }
}


$pythonBinCandidates = ["python3", "python"];
$pythonBin = null;

foreach ($pythonBinCandidates as $cand) {
  $which = trim(shell_exec("command -v " . escapeshellarg($cand) . " 2>/dev/null"));
  if ($which !== "") { $pythonBin = $cand; break; }
}
if ($pythonBin === null) {
  $pythonBin = "python3";
}

$cmd = $pythonBin . " " . escapeshellarg($pyPath)
     . " --csv " . escapeshellarg($csvPath)
     . " --opened_days " . escapeshellarg((string)$openedDays);

if ($storedDays !== null) {
  $cmd .= " --stored_days " . escapeshellarg((string)$storedDays);
}

if ($savedImgPath !== "") {
  $cmd .= " --img " . escapeshellarg($savedImgPath);
}

$cmd .= " 2>&1"; 

$out = shell_exec($cmd);
if ($out === null || trim($out) === "") {
  respond([
    "error" => "Python execution failed or empty output",
    "hint" => "Your host may disable shell_exec/exec. Consider frontend-only scoring or PHP-only scoring.",
    "cmd" => $cmd
  ], 500);
}

$decoded = json_decode($out, true);
if ($decoded === null) {
  respond([
    "error" => "Python did not return valid JSON",
    "raw_output" => $out,
    "cmd" => $cmd
  ], 500);
}

$decoded["_server"] = [
  "has_file" => $hasFile,
  "img_saved" => ($savedImgPath !== ""),
];

respond($decoded, 200);
